%% Description
% Plots figure 7: experimental decrease in force due to tension change.

%% Experimental parameter definitions
%
% t             Time (s). Tension change occurs between t=1292-1296.
%
% T             Membrane tension (N/m). Increase from T=2.5-7.1
%
% F             Measured force (mN).

clear all;close all;

%% Load solution
load('figure7.mat')

%% Plotting
plot(t-1250,F,'linewidth',2)
xlabel('$t$','interpreter','latex')
ylabel('$F$','interpreter','latex')
set(findobj('type','axes'),'fontsize',20,'linewidth',2)
set(gca,'TickLength',2*get(gca,'TickLength'))
axis([0 100 0 40])
